module apply

// LAZY DYNAMICS EXAMPLE  - This application reads in two dynamic, applies them (lazily) to each other
// and saves (lazy) result.

import StdDynamic
import StdDynamicFileIO
import StdEnv

import path					// do NOT forget to change absolute path

:: Tree a = Node a (Tree a) (Tree a) | Leaf

Start world
	// read function
	# (ok,f,world)
		= readDynamic (p +++ "\\function") world
	| not ok
		= abort " could not read"
		

	// value function
	# (ok,v,world)
		= readDynamic (p +++ "\\value") world
	| not ok
		= abort " could not read"

	# applied_dynamic
		= apply f v;
		
	// write dynamic; note that the dynamic contains lazy references to the dynamics
	// 'function' and 'value'.
	#! (ok2,world)
		= writeDynamic (p +++ "\\bool") applied_dynamic world

	| not ok2
		= abort "could not write dynamic"

	= (world);
where
	apply (f :: (Tree Int) -> Real) (v :: (Tree Int))
		= dynamic f v 
	apply _ _
		= abort "unmatched"
